/* --COPYRIGHT--,BSD

 * Copyright (c) 2012, Texas Instruments Incorporated

 * All rights reserved.

 *

 * Redistribution and use in source and binary forms, with or without

 * modification, are permitted provided that the following conditions

 * are met:

 *

 * *  Redistributions of source code must retain the above copyright

 *    notice, this list of conditions and the following disclaimer.

 *

 * *  Redistributions in binary form must reproduce the above copyright

 *    notice, this list of conditions and the following disclaimer in the

 *    documentation and/or other materials provided with the distribution.

 *

 * *  Neither the name of Texas Instruments Incorporated nor the names of

 *    its contributors may be used to endorse or promote products derived

 *    from this software without specific prior written permission.

 *

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"

 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,

 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR

 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR

 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,

 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,

 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;

 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,

 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR

 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,

 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 * --/COPYRIGHT--*/

//! \file   solutions/instaspin_foc/src/user.c

//! \brief Contains the function for setting initialization data to the CTRL, HAL, and EST modules

//!

//! (C) Copyright 2012, Texas Instruments, Inc.



// This file is changed by Powersim Inc.



// **************************************************************************

// the includes



#include <math.h>

#include "user.h"

#include "Include/ctrl.h"



EST_State_e estState;



// **************************************************************************

// the defines





// **************************************************************************

// the typedefs





// **************************************************************************

// the functions

void userUpdate(EST_Handle handle, USER_Params *pUserParams){

	float_t fullScaleInductance = pUserParams->iqFullScaleVoltage_V

		                    / (pUserParams->iqFullScaleCurrent_A

		                    *  pUserParams->voltageFilterPole_rps);

	float_t Ls_coarse_max = _IQ30toF(EST_getLs_coarse_max_pu(handle));

	int_least8_t lShift = ceil(log(pUserParams->motor_Ls_d / (Ls_coarse_max

		                         * fullScaleInductance)) / log(2.0));

	uint_least8_t Ls_qFmt = 30 - lShift;

	float_t L_max = fullScaleInductance * pow(2.0, lShift);

	_iq Ls_d_pu = _IQ30(pUserParams->motor_Ls_d / L_max);

	_iq Ls_q_pu = _IQ30(pUserParams->motor_Ls_q / L_max);





	// store the results

	EST_setLs_d_pu(handle,Ls_d_pu);

	EST_setLs_q_pu(handle,Ls_q_pu);

	EST_setLs_qFmt(handle,Ls_qFmt);

	return;

}



//int estArea[256];

//#ifdef FAST_ROM_V1p6

//int ctrlArea[256];

//#endif

EST_Handle EstInitialization(USER_Params *pUserParams)

{

	EST_Handle handle;

#ifdef FAST_ROM_V1p6

	CTRL_Obj *obj;

	// These function calls are used to initialize the estimator with ROM

	// function calls. It needs the specific address where the controller

	// object is declared by the ROM code.

//	CTRL_Handle ctrlHandle = CTRL_init((void *)ctrlArea, 0x200);

	CTRL_Handle ctrlHandle = CTRL_init(USER_CTRL_HANDLE_ADDRESS, 0x200);

	obj = (CTRL_Obj *)ctrlHandle;



	// initialize the estimator

//	handle = EST_init((void *)estArea, 0x200);

	handle = EST_init(USER_EST_HANDLE_ADDRESS, 0x200);



	// this sets the estimator handle (part of the controller object) to

	// the same value initialized above by the EST_init() function call.

	// This is done so the next function implemented in ROM, can

	// successfully initialize the estimator as part of the controller

	// object.

	obj->estHandle = handle;



	// initialize the estimator through the controller. These three

	// function calls are needed for the F2806xF/M implementation of

	// InstaSPIN.

	CTRL_setParams(ctrlHandle, pUserParams);

	CTRL_setUserMotorParams(ctrlHandle);

	CTRL_setupEstIdleState(ctrlHandle);

#else

	// initialize the estimator

//	handle = EST_init((void *)estArea, 0x200);

	handle = EST_init(USER_EST_HANDLE_ADDRESS, 0x200);



	// initialize the estimator. These two function calls are needed for

	// the F2802xF implementation of InstaSPIN using the estimator handle

	// initialized by EST_init(), these two function calls configure the

	// estimator, and they set the estimator in a proper state prior to

	// spinning a motor.

	EST_setEstParams(handle, pUserParams);

	EST_setupEstIdleState(handle);

#endif

	// disable Rs recalculation

	EST_setFlag_enableRsRecalc(handle, false);

	return handle;

}





USER_ErrorCode_e USER_getErrorCode(USER_Params *pUserParams)

{

  return(pUserParams->errorCode);

} // end of USER_getErrorCode() function





void USER_setErrorCode(USER_Params *pUserParams,const USER_ErrorCode_e errorCode)

{

  pUserParams->errorCode = errorCode;



  return;

} // end of USER_setErrorCode() function





//! \brief     Update the global variables (gMotorVars).

//! \param[in] handle  The estimator (EST) handle

void updateGlobalVariables(EST_Handle handle)

{

    // get the estimator state

	estState = EST_getState(handle);



    return;

} // end of updateGlobalVariables() function



/*

#ifndef NO_CTRL

void USER_calcPIgains(CTRL_Handle handle)

{

  CTRL_Obj *obj = (CTRL_Obj *)handle;

  float_t fullScaleCurrent = USER_IQ_FULL_SCALE_CURRENT_A;

  float_t fullScaleVoltage = USER_IQ_FULL_SCALE_VOLTAGE_V;

  float_t ctrlPeriod_sec = CTRL_getCtrlPeriod_sec(handle);

  float_t Ls_d;

  float_t Ls_q;

  float_t Rs;

  float_t RoverLs_d;

  float_t RoverLs_q;

  _iq Kp_Id;

  _iq Ki_Id;

  _iq Kp_Iq;

  _iq Ki_Iq;

  _iq Kd;



#ifdef __TMS320C28XX_FPU32__

  int32_t tmp;



  // when calling EST_ functions that return a float, and fpu32 is enabled, an integer is needed as a return

  // so that the compiler reads the returned value from the accumulator instead of fpu32 registers

  tmp = EST_getLs_d_H(obj->estHandle);

  Ls_d = *((float_t *)&tmp);



  tmp = EST_getLs_q_H(obj->estHandle);

  Ls_q = *((float_t *)&tmp);



  tmp = EST_getRs_Ohm(obj->estHandle);

  Rs = *((float_t *)&tmp);

#else

  Ls_d = EST_getLs_d_H(obj->estHandle);



  Ls_q = EST_getLs_q_H(obj->estHandle);



  Rs = EST_getRs_Ohm(obj->estHandle);

#endif



  RoverLs_d = Rs/Ls_d;

  Kp_Id = _IQ((0.25*Ls_d*fullScaleCurrent)/(ctrlPeriod_sec*fullScaleVoltage));

  Ki_Id = _IQ(RoverLs_d*ctrlPeriod_sec);



  RoverLs_q = Rs/Ls_q;

  Kp_Iq = _IQ((0.25*Ls_q*fullScaleCurrent)/(ctrlPeriod_sec*fullScaleVoltage));

  Ki_Iq = _IQ(RoverLs_q*ctrlPeriod_sec);



  Kd = _IQ(0.0);



  // set the Id controller gains

  PID_setKi(obj->pidHandle_Id,Ki_Id);

  CTRL_setGains(handle,CTRL_Type_PID_Id,Kp_Id,Ki_Id,Kd);



  // set the Iq controller gains

  PID_setKi(obj->pidHandle_Iq,Ki_Iq);

  CTRL_setGains(handle,CTRL_Type_PID_Iq,Kp_Iq,Ki_Iq,Kd);



  return;

} // end of calcPIgains() function

#endif

*/

/*

//! \brief     Computes the scale factor needed to convert from torque created by Ld, Lq, Id and Iq, from per unit to Nm

//!

_iq USER_computeTorque_Ls_Id_Iq_pu_to_Nm_sf(void)

{

  float_t FullScaleInductance = (USER_IQ_FULL_SCALE_VOLTAGE_V/(USER_IQ_FULL_SCALE_CURRENT_A*USER_VOLTAGE_FILTER_POLE_rps));

  float_t FullScaleCurrent = (USER_IQ_FULL_SCALE_CURRENT_A);

  float_t lShift = ceil(log(USER_MOTOR_Ls_d/(0.7*FullScaleInductance))/log(2.0));



  return(_IQ(FullScaleInductance*FullScaleCurrent*FullScaleCurrent*USER_MOTOR_NUM_POLE_PAIRS*1.5*pow(2.0,lShift)));

} // end of USER_computeTorque_Ls_Id_Iq_pu_to_Nm_sf() function





//! \brief     Computes the scale factor needed to convert from torque created by flux and Iq, from per unit to Nm

//!

_iq USER_computeTorque_Flux_Iq_pu_to_Nm_sf(void)

{

  float_t FullScaleFlux = (USER_IQ_FULL_SCALE_VOLTAGE_V/(float_t)USER_EST_FREQ_Hz);

  float_t FullScaleCurrent = (USER_IQ_FULL_SCALE_CURRENT_A);

  float_t maxFlux = (USER_MOTOR_RATED_FLUX*((USER_MOTOR_TYPE==MOTOR_Type_Induction)?0.05:0.7));

  float_t lShift = -ceil(log(FullScaleFlux/maxFlux)/log(2.0));



  return(_IQ(FullScaleFlux/(2.0*MATH_PI)*FullScaleCurrent*USER_MOTOR_NUM_POLE_PAIRS*1.5*pow(2.0,lShift)));

} // end of USER_computeTorque_Flux_Iq_pu_to_Nm_sf() function





//! \brief     Computes the scale factor needed to convert from per unit to Wb

//!

_iq USER_computeFlux_pu_to_Wb_sf(void)

{

  float_t FullScaleFlux = (USER_IQ_FULL_SCALE_VOLTAGE_V/(float_t)USER_EST_FREQ_Hz);

  float_t maxFlux = (USER_MOTOR_RATED_FLUX*((USER_MOTOR_TYPE==MOTOR_Type_Induction)?0.05:0.7));

  float_t lShift = -ceil(log(FullScaleFlux/maxFlux)/log(2.0));



  return(_IQ(FullScaleFlux/(2.0*MATH_PI)*pow(2.0,lShift)));

} // end of USER_computeFlux_pu_to_Wb_sf() function





//! \brief     Computes the scale factor needed to convert from per unit to V/Hz

//!

_iq USER_computeFlux_pu_to_VpHz_sf(void)

{

  float_t FullScaleFlux = (USER_IQ_FULL_SCALE_VOLTAGE_V/(float_t)USER_EST_FREQ_Hz);

  float_t maxFlux = (USER_MOTOR_RATED_FLUX*((USER_MOTOR_TYPE==MOTOR_Type_Induction)?0.05:0.7));

  float_t lShift = -ceil(log(FullScaleFlux/maxFlux)/log(2.0));



  return(_IQ(FullScaleFlux*pow(2.0,lShift)));

} // end of USER_computeFlux_pu_to_VpHz_sf() function





//! \brief     Computes Flux in Wb or V/Hz depending on the scale factor sent as parameter

//!

_iq USER_computeFlux(CTRL_Handle handle, const _iq sf)

{

  CTRL_Obj *obj = (CTRL_Obj *)handle;



  return(_IQmpy(EST_getFlux_pu(obj->estHandle),sf));

} // end of USER_computeFlux() function





//! \brief     Computes Torque in Nm

//!

_iq USER_computeTorque_Nm(CTRL_Handle handle, const _iq torque_Flux_sf, const _iq torque_Ls_sf)

{

  CTRL_Obj *obj = (CTRL_Obj *)handle;



  _iq Flux_pu = EST_getFlux_pu(obj->estHandle);

  _iq Id_pu = PID_getFbackValue(obj->pidHandle_Id);

  _iq Iq_pu = PID_getFbackValue(obj->pidHandle_Iq);

  _iq Ld_minus_Lq_pu = _IQ30toIQ(EST_getLs_d_pu(obj->estHandle)-EST_getLs_q_pu(obj->estHandle));

  _iq Torque_Flux_Iq_Nm = _IQmpy(_IQmpy(Flux_pu,Iq_pu),torque_Flux_sf);

  _iq Torque_Ls_Id_Iq_Nm = _IQmpy(_IQmpy(_IQmpy(Ld_minus_Lq_pu,Id_pu),Iq_pu),torque_Ls_sf);

  _iq Torque_Nm = Torque_Flux_Iq_Nm + Torque_Ls_Id_Iq_Nm;



  return(Torque_Nm);

} // end of USER_computeTorque_Nm() function





//! \brief     Computes Torque in Nm

//!

_iq USER_computeTorque_lbin(CTRL_Handle handle, const _iq torque_Flux_sf, const _iq torque_Ls_sf)

{

  CTRL_Obj *obj = (CTRL_Obj *)handle;



  _iq Flux_pu = EST_getFlux_pu(obj->estHandle);

  _iq Id_pu = PID_getFbackValue(obj->pidHandle_Id);

  _iq Iq_pu = PID_getFbackValue(obj->pidHandle_Iq);

  _iq Ld_minus_Lq_pu = _IQ30toIQ(EST_getLs_d_pu(obj->estHandle)-EST_getLs_q_pu(obj->estHandle));

  _iq Torque_Flux_Iq_Nm = _IQmpy(_IQmpy(Flux_pu,Iq_pu),torque_Flux_sf);

  _iq Torque_Ls_Id_Iq_Nm = _IQmpy(_IQmpy(_IQmpy(Ld_minus_Lq_pu,Id_pu),Iq_pu),torque_Ls_sf);

  _iq Torque_Nm = Torque_Flux_Iq_Nm + Torque_Ls_Id_Iq_Nm;



  return(_IQmpy(Torque_Nm, _IQ(MATH_Nm_TO_lbin_SF)));

} // end of USER_computeTorque_lbin() function



*/



int CalFixPtPos(float_t val)

{

	int len = 30;

	float_t f = 2.0;

	if (val < 0)

		val = -val;



	while (val > f) {

		f *= 2;

		len--;

	}

	if (len < 0)

		len = 0;

	return len;

}



// end of file



